<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\Models\Investors;
use App\Models\User;
use App\Models\Deal;
use App\Models\DealInvestments;

class AdminController extends Controller {

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index() {
        $investors = Investors::with('user')->orderBy('created_at', 'desc')->limit(10)->get();

        $userCountsResult = DB::table('users')
                ->select(DB::raw('DATE_FORMAT(created_at, "%b") as month'), DB::raw('COUNT(*) as count'))
                ->groupBy('month')
                ->orderByRaw('MONTH(created_at)')
                ->get();

        // Initialize an associative array to store month counts
        $monthCounts = [];

        foreach ($userCountsResult as $count) {
            // Convert the month name to lowercase before storing it in the array
            $monthCounts[strtolower($count->month)] = $count->count;
        }

        $months = ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'];
        $userCounts = [];

        foreach ($months as $month) {
            // Convert the month to lowercase and check if it exists in the array, then use the count
            $userCounts[] = $monthCounts[strtolower($month)] ?? 0;
        }

        /*         * * * */

        $investorCountsResult = DB::table('deal_investments')
                ->select(DB::raw('MONTH(created_at) as month'), DB::raw('COUNT(DISTINCT investor_id) as count'))
                ->groupBy('month')
                ->orderByRaw('MONTH(created_at)')
                ->get();

        $investmentSumsResult = DB::table('deal_investments')
                ->select(DB::raw('MONTH(created_at) as month'), DB::raw('SUM(invested_amt) as sum'))
                ->groupBy('month')
                ->orderByRaw('MONTH(created_at)')
                ->get();

        $months = [];

        // Initialize data arrays with 0 values for all months
        for ($i = 1; $i <= 12; $i++) {
            $months[] = date('M', strtotime("2023-$i-01")); // Assuming the year 2023
        }

        $investorCounts = array_fill(0, 12, 0);
        $investmentSums = array_fill(0, 12, 0);

        // Fill in the data arrays with the retrieved counts and sums
        foreach ($investorCountsResult as $count) {
            $index = $count->month - 1; // Subtract 1 to account for array indexing
            $investorCounts[$index] = $count->count;
        }

        foreach ($investmentSumsResult as $sum) {
            $index = $sum->month - 1; // Subtract 1 to account for array indexing
            $investmentSums[$index] = $sum->sum;
        }

        $adminCount = User::where('roleid', 1)->count();
        $investorCount = User::where('roleid', 2)->count();
        $investorCountsCD = Investors::with('user')->whereDate('created_at', now()->toDateString())->count();
        $dealsCount = DealInvestments::count();
        $dealsCountCD = DealInvestments::whereDate('created_at', now()->toDateString())->count();
        $totalInvestment = DealInvestments::sum('invested_amt');

        $deals = Deal::withCount(['dealInvestments as total_investors' => function ($query) {
                        $query->select(DB::raw('count(*)'))->groupBy('deal_id');
                    }])->limit(5)->get();

        return view('home', compact('investors', 'userCounts', 'investorCounts', 'investorCountsCD', 'investmentSums',
                        'adminCount', 'investorCount', 'dealsCount', 'dealsCountCD', 'totalInvestment', 'deals'));
    }

    public function profile() {
        return view('admin.profile');
    }

    public function adminUsers() {
        //$currentUser = Auth::user();

        $admins = User::where('roleid', 1)
                ->orderBy('created_at', 'desc')
                ->paginate(10);
        return view('admin.admin_users.list', compact('admins'));
    }

    public function updateStatus(Request $request) {
        $uId = $request->input('user_id'); // Assuming you have a deal_id in your form
        $newStatus = $request->input('new_status');

        try {
            $deal = User::findOrFail($uId);

            // Update the status field in the database
            $deal->is_active = $newStatus;
            $deal->save();

            return response()->json(['message' => 'User status updated successfully'], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Failed to update user status'], 500);
        }
    }

    public function addAdminUsers() {
        return view('admin.admin_users.add');
    }

    public function storeAdminUsers(Request $request) {
        // Validate the request data
        $request->validate([
            'name' => 'required|string',
            'email' => 'required|email|unique:users',
            'password' => 'required|string|confirmed',
        ]);

        // Create a user record in the users table
        $user = User::create([
                    'name' => $request->input('name'),
                    'email' => $request->input('email'),
                    'password' => Hash::make($request->input('password')),
        ]);

        $user->roleid = 1;
        $user->save();

        return redirect()->route('admin.users.list')->with('success', 'Admin added successfully');
    }

    public function getReports() {
        
        $investments = DealInvestments::select('deal_investments.*', 'deals.deal_name', 'deals.total_investment', 'deals.start_date', 'deals.end_date',
                'investors.firstname','investors.lastname','investors.phone','investors.email')
                ->join('deals', 'deal_investments.deal_id', '=', 'deals.id')
                ->join('investors', 'deal_investments.investor_id', '=', 'investors.user_id')
                ->get();
        
        //echo "<pre>";
        //print_r($investments);exit;
        return view('admin.reports', compact('investments'));
    }

    public function errorpage() {
        return view('404');
    }
}
