<?php

namespace App\Http\Controllers\Investor;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\DealInvestments;
use App\Models\Investors;
use App\Models\Deal;
use App\Models\InvestorTax;

class InvestorController extends Controller {

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index() {
        $uid = Auth::id();
        /*         * * * */
        $investorCountsResult = DB::table('deal_investments')
                ->select(DB::raw('MONTH(created_at) as month'), DB::raw('COUNT(DISTINCT investor_id) as count'))
                ->where('investor_id', $uid)
                ->groupBy('month')
                ->orderByRaw('MONTH(created_at)')
                ->get();

        $investmentSumsResult = DB::table('deal_investments')
                ->select(DB::raw('MONTH(created_at) as month'), DB::raw('SUM(invested_amt) as sum'))
                ->where('investor_id', $uid)
                ->groupBy('month')
                ->orderByRaw('MONTH(created_at)')
                ->get();

        $months = [];

        // Initialize data arrays with 0 values for all months
        for ($i = 1; $i <= 12; $i++) {
            $months[] = date('M', strtotime("2023-$i-01")); // Assuming the year 2023
        }

        $investorCounts = array_fill(0, 12, 0);
        $investmentSums = array_fill(0, 12, 0);

        // Fill in the data arrays with the retrieved counts and sums
        foreach ($investorCountsResult as $count) {
            $index = $count->month - 1; // Subtract 1 to account for array indexing
            $investorCounts[$index] = $count->count;
        }

        foreach ($investmentSumsResult as $sum) {
            $index = $sum->month - 1; // Subtract 1 to account for array indexing
            $investmentSums[$index] = $sum->sum;
        }
        
        $dealsCount = DealInvestments::where('investor_id', $uid)->count();
        $totalInvestment = DealInvestments::where('investor_id', $uid)->sum('invested_amt');
        
         $investments = DealInvestments::with('deals')->where('investor_id', $uid)->get();

        return view('investor.dashboard', compact('investorCounts', 'investmentSums', 'dealsCount', 'totalInvestment', 'investments'));
    }

    public function profile() {
        $uid = Auth::id();

        $profile = Investors::where('user_id', $uid)->first();
        $investments = DealInvestments::where('investor_id', $uid)->count();
        $totalIInvestment = DealInvestments::where('investor_id', $uid)->sum('invested_amt');

        return view('investor.profile', compact('profile', 'investments', 'totalIInvestment'));
    }

    public function deals() {
        $uid = Auth::id();

        $investments = DealInvestments::with('deals')->where('investor_id', $uid)->get();
        return view('investor.deals', compact('investments'));
    }

    public function investments() {
        $uid = Auth::id();
        $investments = DealInvestments::with('deals')->where('investor_id', $uid)->get();
        return view('investor.investments', compact('investments'));
    }
    
    public function dealDeatils($id) {
        $uid = Auth::id();
        $deal = Deal::with('dealDocuments')->findOrFail($id);

        // Get the investments for the deal and eager load the associated users
        $investments = DealInvestments::with('deals')->where('investor_id', $uid)->where('deal_id', $id)->get();
        $dealDocuments = $deal->dealDocuments;
        
        $taxes = InvestorTax::where('investor_id', $uid)->where('deal_id', $id)->get();

        return view('investor.details', compact('deal', 'dealDocuments', 'investments', 'taxes'));
    }
    
    public function downloadDocument($filename, $filetyp) {
        // Define the directory where the PDFs are stored
        if($filetyp == 'tax'){
            $directory = 'uploads/deals/taxes';
        }else{
            $directory = 'uploads/deals/documents';
        }

        // Ensure that the filename is safe and sanitize it
        $filename = Str::of($filename)->basename();

        // Define the full path to the PDF file
        $filePath = public_path($directory . '/' . $filename);

        // Check if the file exists
        if (file_exists($filePath)) {
            // Determine the MIME type (PDF)
            $mimeType = 'application/pdf';

            // Generate a unique name for the downloaded file
            $downloadFilename = 'document_' . time() . '.pdf';

            // Set headers to force download
            header("Cache-Control: public");
            header("Content-Description: File Transfer");
            header("Content-Disposition: attachment; filename=$downloadFilename");
            header("Content-Type: $mimeType");
            header("Content-Transfer-Encoding: binary");

            // Read the file and output it to the response
            readfile($filePath);
        } else {
            // File not found, you can handle this case as needed
            abort(404, 'File not found');
        }
    }
    
}
