@extends('layouts.app_backend')

@section('content')
<div class="container-full">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="callout callout-success" style="display: none;">

                </div>
                @if(session('success'))
                    <div class="card card-body" id="success-card">
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Success!</strong> {{ session('success') }}
                        </div>
                    </div>

                    <script>
                        // Auto close the success alert card after 5 seconds
                        setTimeout(function() {
                            $('#success-card').fadeOut();
                        }, 5000);
                    </script>
                @endif
                <div class="box">
                    <div class="box-header with-border">
                        <div class="row justify-content-between">
                            <div class="col"><h4 class="box-title">All Investors</h4></div>
                            <div class="col-auto">
                                <a href="{{ route('add.investors') }}" class="waves-effect mx-10 waves-light btn btn-sm btn-primary">ADD INVESTORS</a>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="investmentlist" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                <thead>
                                    <tr class="bg-info-light">
                                        <th>No</th>
                                        <th>Firstname</th>
                                        <th>Lastname</th>
                                        <th>Email Address</th>
                                        <th>Phone Number</th>
                                        <th>Registered On</th>
                                        <th>User Activation</th>
                                    </tr>
                                <thead>
                                <tbody>
                                    @foreach ($investors as $investor)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><strong>{{ $investor->firstname }}</strong></td>
                                        <td><strong>{{ $investor->lastname }}</strong></td>
                                        <td>{{ $investor->email }}</td>
                                        <td>{{ $investor->phone }}</td>
                                        <td>{{ $investor->created_at->format('d-m-y') }}</td>
                                        <td>
                                            <input type="hidden" id="status" name="status" value="{{ $investor->user->is_active }}">
                                            <label class="switch">
                                                <input type="checkbox" data-user-id="{{ $investor->user->id }}" id="statusToggle" @if ($investor->user->is_active == 1) checked @endif onchange="updateInvestorStatus()">
                                                <span class="slider"></span>
                                            </label>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>							
                    <div class="box-footer bg-light py-10 with-border">
                        <div class="d-flex align-items-center justify-content-between">
                            <p class="mb-0">Total {{ count($investors) }} Investors</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>			
    </section>
    <!-- /.content -->
</div>
<script>
    $('#investmentlist').DataTable();

    function updateInvestorStatus() {
        const statusToggle = document.getElementById("statusToggle");
        const currentStatus = statusToggle.checked ? 1 : 0;
        const userId = statusToggle.getAttribute("data-user-id");

        //console.log(dealId);

        const confirmed = confirm("Are you sure you want to update the deal status?");

        if (confirmed) {
            // Send an AJAX request to update the status in the database.
            updateStatusInDatabase(userId, currentStatus);
        } else {
            // Restore the switch to its previous state.
            statusToggle.checked = !statusToggle.checked;
        }
    }
    function updateStatusInDatabase(userId, newStatus) {
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        // Perform an AJAX request to update the status in the database.
        $.ajax({
            type: "POST",
            url: "{{ route('admin.user.status') }}", // Replace with the actual URL endpoint.
            data: {_token: csrfToken, user_id: userId, new_status: newStatus},
            success: function (response) {
                $('.callout-success').css("display", "block");
                $('.callout-success').text(response.message);
                setTimeout(function () {
                    location.reload();
                }, 2000);
            },
            error: function (error) {
                // Handle error, if needed.
                console.error(error);
            }
        });
    }

</script>
@endsection