@extends('layouts.app_backend')

@section('content')
@if(session('success'))
<div class="card card-body" id="success-card">
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Success!</strong> {{ session('success') }}
    </div>
</div>

<script>
    // Auto close the success alert card after 5 seconds
    setTimeout(function () {
        $('#success-card').fadeOut();
    }, 5000);
</script>
@endif
<div class="card card-body" id="success-card" style="display: none;">
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Success!</strong>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
</div>

<div class="container-full">
    <section class="content">
        <div class="row">
            <div class="col-lg-12">
                <div class="box">
                    <div class="box-body">
                        <h4 class="box-title">Primary Table</h4>
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="bg-primary">
                                    <tr>
                                        <th>#</th>
                                        <th>Full Name</th>
                                        <th>Email</th>
                                        <th>Phone Number</th>
                                        <th>Location</th>
                                        <th>Activity</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($realtors as $realtor)
                                    <tr>
                                        <td>{{ $realtors->firstItem() + $loop->index }}</td>
                                        <td>{{ $realtor->firstname }} {{ $realtor->lastname }}</td>
                                        <td>{{ $realtor->email }}</td>
                                        <td>{{ $realtor->phone }}</td>
                                        <td>{{ $realtor->location }}</td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" class="activity-switch" data-user-id="{{ $realtor->user_id }}" {{ $realtor->user->is_active == 1 ? 'checked' : '' }}>
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                        <td>
                                            <a href=""><i class="fa fa-edit" style="font-size: 24px;"></i></a>
                                            <span style="padding: 0 5px"></span>
                                            <a href=""><i class="fa fa-trash" style="font-size: 24px; color: red;"></i></a>
                                        </td>
                                        <!-- Add other table data columns as needed -->
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            {{ $realtors->links() }} <!-- Display pagination links -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
    $(document).ready(function () {
        $('.activity-switch').on('change', function () {
            const userId = $(this).data('user-id');
            const isActive = $(this).is(':checked') ? 1 : 0;

            //alert(isActive);

            $.ajax({
                type: 'POST',
                url: '{{ route("update.realtor.activity") }}', // Replace with your actual route
                data: {
                    '_token': '{{ csrf_token() }}',
                    userId: userId,
                    isActive: isActive
                },
                success: function (response) {
                    // Show the success card
                    $('#success-card').fadeIn();

                    // Automatically hide the success card after 3 seconds
                    setTimeout(function () {
                        $('#success-card').fadeOut();
                    }, 3000);

                    // Reload the page after 3 seconds
                    setTimeout(function () {
                        location.reload();
                    }, 3000);
                },
                error: function (xhr, status, error) {
                    // Handle error, e.g., show an error message
                    console.error(xhr.responseText);
                }
            });
        });
    });
</script>
@endsection