@extends('layouts.app_backend')

@section('content')
<div class="container-fluid">
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="me-auto">
                <div class="d-inline-block align-items-center">
                    <nav>
                        <ol class="breadcrumb">
                            <li><a href="#">Home<i class="fa-solid fa-angles-right"></i></a></li>
                            <li ><a href="#" class="breadcrumb-active">Investment Reports</a></li>
                        </ol>
                    </nav>
                </div>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="reports" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Deal Name</th>
                                        <th>Investor</th>
                                        <th>Contact</th>
                                        <th>Email Address</th>
                                        <th>Invested</th>
                                        <th>Investment Date</th>
                                        <th>Deal Start Date</th>
                                        <th>Deal Close Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($investments as $investment)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><strong><a href="{{ route('investor.deal.details', $investment->deal_id) }}">{{ $investment->deal_name }}</a></strong></td>
                                        <td>{{ $investment->firstname }} {{ $investment->lastname }}</td>
                                        <td>{{ $investment->phone }}</td>
                                        <td>{{ $investment->email }}</td>
                                        <td>{{ $investment->invested_amt }}</td>
                                        <td>{{ $investment->invested_on }}</td>
                                        <td>{{ $investment->start_date }}</td>
                                        <td>{{ $investment->end_date }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

</div>

<script>
    $('#reports').DataTable({
        dom: 'Bfrtip', // Show buttons below the table
        buttons: [
            'excel', 'csv' // Enable Excel and CSV buttons
        ]
    });
</script>
@endsection