@extends('layouts.app_base')

@section('content')
<div id="loginblock" class="container-fluid nopad">
    <div class="row no-gutters">
        <div class="col-md-12 col-lg-6">
            <div class="login-box center">
                <h3>
                    <a class="navbar-brand" href="{{ url('/login') }}">
                        {{ config('app.name', 'Laravel') }}
                    </a>
                </h3>
                <p>If you are not yet registered, it will create an account for you.</p>
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    <div class="col-md-12 form-group">
                        <label for="email">Email ID</label>
                        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                        @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-12 form-group">
                        <label for="password">Password</label>
                        <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password"> 
                        @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <button type="submit" class="waves-effect waves-light btn btn-success mb-5 text-white btn-full-width">Get verification link on my mail</button>
                    
                    <div class="mt-3">
                        <p class="text-center cursor bold-text"><a href="{{ route('register') }}">Create New Account!</a></p>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-12 col-lg-6">
            <img src="{{ asset('assets/images/login.jpg') }}" width="100%" alt="Preview">
        </div>
    </div>
</div>

@endsection
