@extends('layouts.app_base')

@section('content')
<div id="loginblock" class="container-fluid nopad">
    <div class="row no-gutters">
        <div class="col-md-12 col-lg-6">
            <div class="login-box center">
                <h3>
                    <a class="navbar-brand" href="{{ url('/login') }}">
                        {{ config('app.name', 'Laravel') }}
                    </a>
                </h3>
                <p>If you are not yet registered, it will create an account for you.</p>
                <form method="POST" action="{{ route('register') }}">
                    @csrf
                    
                    <div class="col-md-12 form-group">
                        <label for="name">{{ __('First Name') }}</label>
                        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>
                        @error('name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                    
                    <div class="col-md-12 form-group">
                        <label for="name">{{ __('Last Name') }}</label>
                        <input id="lastname" type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname') }}" required autocomplete="lastname" autofocus>
                        @error('lastname')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="email">{{ __('Email Address') }}</label>
                        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">
                        @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                    
                    <div class="col-md-12 form-group">
                        <label for="phone">{{ __('Phone Number') }}</label>
                        <input id="text" type="phone" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}" required autocomplete="phone">
                        @error('phone')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="password">{{ __('Password') }}</label>
                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                        @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="password-confirm">{{ __('Confirm Password') }}</label>
                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                    </div>

                    <div class="col-md-12 text-center form-group">
                        <button type="submit" class="btn btn-primary text-white">REGISTER NOW</button>
                    </div>
                    
                    <div class="mt-3 text-center">
                        <a href="{{ route('login') }}" class="bold-text">Click! If Already Have Account!</a><br>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-12 col-lg-6">
            <img src="{{ asset('assets/images/login.jpg') }}" width="100%" alt="Preview">
        </div>
    </div>
</div>
@endsection
