@extends('layouts.app_investor')

@section('content')
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<div class="container-full">
    <section class="content">
        <div class="callout callout-success" style="display: none;">

        </div>
        @if(session('success'))
        <div class="card card-body" id="success-card">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> {{ session('success') }}
            </div>
        </div>

        <script>
// Auto close the success alert card after 5 seconds
setTimeout(function () {
    $('#success-card').fadeOut();
}, 5000);
        </script>
        @endif
        <div class="box">
            <div class="box-body">
                <div class="px-20 bb-1 pb-15 d-flex align-items-center justify-content-between">
                    <h4 class="mb-0">{{ $deal->deal_name }}</h4>
                    
                </div>
            </div>

            <div class="box-body">
                <div class="row">
                    <div class="col col-5">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="">Documents</h4>
                            </div>
                            <div class="box-body">	
                                @if(count($dealDocuments) > 0)
                                @foreach($dealDocuments as $document)
                                <div class="mb-10 d-flex justify-content-between align-items-center">
                                    <div class="fw-600 min-w-120">
                                        <i class="fa-solid fa-arrow-up"></i> {{ $document->created_at->format('d-m-y') }} <!-- Display the document creation date -->
                                    </div>
                                    <div class="w-p100 p-10 rounded10 justify-content-between align-items-center d-flex bg-lightest">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <h6 class="mb-0" style="text-transform: uppercase;">{{ $document->document_name }}</h6>
                                            </div>
                                        </div>
                                        <div class="dropdown">
                                            <a data-bs-toggle="dropdown" href="#"><i class="ti-more-alt rotate-90"></i></a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <!-- Provide a link to download the document PDF -->
                                                <a class="dropdown-item" href="{{ route('investor.download.document', ['filename' => $document->document_file, 'filetyp' => 'docx']) }}" target="_blank"><i class="ti-import"></i> Download</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                @else
                                <div class="media flex-column text-center p-40 bg-gray-100 mb-20">
                                    <span class="avatar avatar-xl bg-warning opacity-60 mx-auto">
                                        <i class="align-sub fa-solid fa-x fs-40"></i>
                                    </span>
                                    <div class="mt-20">
                                        <h6 class="text-uppercase fw-500">SORRY!</h6>
                                        <small>You haven't uploaded any yet.</small>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        
                        <div class="box mt-4">
                            <div class="box-header">
                                <h4 class="">My Taxes</h4>
                            </div>
                            <div class="box-body">	
                                @if(count($taxes) > 0)
                                @foreach($taxes as $tax)
                                <div class="mb-10 d-flex justify-content-between align-items-center">
                                    <div class="fw-600 min-w-120">
                                        <i class="fa-solid fa-arrow-up"></i> {{ $tax->created_at->format('d-m-y') }} <!-- Display the document creation date -->
                                    </div>
                                    <div class="w-p100 p-10 rounded10 justify-content-between align-items-center d-flex bg-lightest">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <h6 class="mb-0" style="text-transform: uppercase;">{{ $tax->file_name }}</h6>
                                            </div>
                                        </div>
                                        <div class="dropdown">
                                            <a data-bs-toggle="dropdown" href="#"><i class="ti-more-alt rotate-90"></i></a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <!-- Provide a link to download the document PDF -->
                                                <a class="dropdown-item" href="{{ route('investor.download.document', ['filename' => $tax->tax_file, 'filetyp' => 'tax']) }}" target="_blank"><i class="ti-import"></i> Download</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                @else
                                <div class="media flex-column text-center p-40 bg-gray-100 mb-20">
                                    <span class="avatar avatar-xl bg-warning opacity-60 mx-auto">
                                        <i class="align-sub fa-solid fa-x fs-40"></i>
                                    </span>
                                    <div class="mt-20">
                                        <h6 class="text-uppercase fw-500">SORRY!</h6>
                                        <small>You haven't uploaded any yet.</small>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col col-7">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="">My Investments</h4>
                            </div>
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table id="myinvestments" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Deal Name</th>
                                                <th>Deal Start Date</th>
                                                <th>Deal Close Date</th>
                                                <th>Invested</th>
                                                <th>Investment Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($investments as $investment)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $investment->deals->deal_name }}</td>
                                                <td>{{ $investment->deals->start_date }}</td>
                                                <td>{{ $investment->deals->end_date }}</td>
                                                <td>{{ $investment->invested_amt }}</td>
                                                <td>{{ $investment->invested_on }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
    </section>
</div>
<!-- Modal -->
<div class="modal fade" id="modal-center" tabindex="-1" aria-labelledby="modal-center-title" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modal-center-title">Edit 
                    <span id="investorName" style="text-transform: uppercase; font-weight: 600;"></span> Investment Data
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Edit form goes here -->
                <form id="editInvestmentForm">
                    @csrf
                    <input type="hidden" id="investmentId" name="investment_id" value="">
                    <div class="mb-3">
                        <label for="investedAmt" class="form-label">Invested Amount</label>
                        <input type="text" class="form-control" id="investedAmt" name="invested_amt">
                    </div>
                    <div class="mb-3">
                        <label for="investedOn" class="form-label">Invested On</label>
                        <input type="date" class="form-control" id="investedOn" name="invested_on">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="saveInvestmentBtn">Save changes</button>
            </div>
        </div>
    </div>
</div>
@endsection


